<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CalculateLinkBudgetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            //
            return [
                'tx_power'          => 'required|numeric',
                'tx_antenna_gain'   => 'required|numeric',
                'rx_antenna_gain'   => 'required|numeric',
                'frequency'         => 'required|numeric|min:0.01',
                'start_lat'         => 'required|numeric|between:-90,90',
                'start_lon'         => 'required|numeric|between:-180,180',
                'end_lat'           => 'required|numeric|between:-90,90',
                'end_lon'           => 'required|numeric|between:-180,180',
                'start_height'      => 'required|numeric|min:0',
                'end_height'        => 'required|numeric|min:0',
            ];
        ];
    }
}
